*openUBMC 支持redfish接口补齐Storages和Drive相关资源*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>通用硬件</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>牛诗然</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/11/1</td>
    </tr>
</table>


**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/11/1</td>
        <td>1.0</td>
        <td>完成详细设计文档</td>
        <td>牛诗然</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->

该需求为支持redfish接口补充资源，分为Storages相关资源和Drive相关资源

1）Storages相关资源：URI：/redfish/v1/Systems/{ComputerSystemId}/Storages/{StorageId}

- 在oem下新增JbodStateSupported字段，该字段代表：Raid卡是否支持将物理磁盘设置为JBOD模式，JBOD模式下操作系统以直通（不经过raid卡）的方式访问磁盘
- 在oem下新增EpdSupported字段，该字段代表：Raid卡是否支持EPD功能，EPD功能下，RAID卡会自动并立即向新插入的硬盘进行供电
- 在oem下CapacitanceStatus对象下新增Severity字段，该字段用来量化电容故障或异常状态的严重程度，包括：“Informational”，“Warning”，“Critical”
- 在oem下CapacitanceStatus对象下新增FaultDetails字段，该字段代表电容状态的具体信息

2）Drive相关资源：URI：/redfish/v1/ChassisId/{ChassisId}/Drives/{DriveId}

- 支持在oem下新增FormFactor字段，该字段代表硬盘的尺寸

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->

1）在oem下新增JbodStateSupported字段：

- 字段类型为布尔类型，取值为true/false
- 该字段已经在资源协作接口上存在，只需要在redfish做映射

2）在oem下新增EpdSupported字段：

- 字段类型为布尔类型，取值为true/false
- 该字段已经在资源协作接口上存在，只需要在redfish做映射

3）在oem下CapacitanceStatus对象下新增Severity字段：

- 字段类型为字符串类型，取值为：“Informational”，“Minor”，“Major”，“Critical”，null
- 该字段关联CapacitanceStatus对象下的 State 和 Health 字段，取值受其完全决定
- 需要根据两个字段做一个逻辑映射

4）在oem下CapacitanceStatus对象下新增FaultDetails字段：

- 字段类型为字符串类型，取值为：

  | 字段值                       | 对应整数值 |
  | ---------------------------- | ---------- |
  | Voltage Low                  | bit0 --- 1 |
  | Battery Needs To Be Replaced | bit1 --- 1 |
  | Learn Cycle Failed           | bit2 --- 1 |
  | Learn Cycle Timeout          | bit3 --- 1 |
  | Pack is about to fail        | bit4 --- 1 |
  | Remaining Capacity Low       | bit5 --- 1 |
  | No Space for Cache Offload   | bit6 --- 1 |
  | 保留字段                      | bit7      |
  | null                         | 0          |

- 该字段已经在资源协作接口上存在，只需要在redfish做映射，将数值映射为字符串

5）支持在oem下新增FormFactor字段：

- 字段类型为字符串类型，取值为：

  | 字段值             | 对应的整数值 |
  | ------------------ | ------------ |
  | Unknown            | 0            |
  | 5.25 inch          | 1            |
  | 3.5 inch           | 2            |
  | 2.5 inch           | 3            |
  | 1.8 inch           | 4            |
  | Less than 1.8 inch | 5            |
  | mSATA              | 6            |
  | M.2                | 7            |
  | MicroSSD           | 8            |
  | CFast              | 9            |
  | null               | 255          |

- 该字段来源于硬盘信息(pd_info)中的form_factor字段，为整数类型，需要获取后做

## 1.3 功能场景

<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

1.对象：网关、运维人员、开发人员使用redfish接口查询相关信息

2.使用时间频率：不频繁





## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 在oem下新增JbodStateSupported字段 | 在oem下新增JbodStateSupported字段 |
| 2 | 在oem下新增EpdSupported字段 | 在oem下新增EpdSupported字段 |
| 3 | 在oem下CapacitanceStatus对象下新增Severity字段 | 在oem下CapacitanceStatus对象下新增Severity字段 |
| 4 | 在oem下CapacitanceStatus对象下新增FaultDetails字段 | 在oem下CapacitanceStatus对象下新增FaultDetails字段 |
| 5 | 在oem下新增FormFactor字段 | 在oem下新增FormFactor字段 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

1）在oem下新增JbodStateSupported字段：

- 从资源协作接口获取属性值 JbodSupported，在redfish做映射

2）在oem下新增EpdSupported字段：

- 从资源协作接口获取属性值 EpdSupported，在redfish做映射

3）在oem下CapacitanceStatus对象下新增Severity字段：

- 从资源协作接口获取属性值 State 和 Health，在redfish做映射

- 映射时如果State不在位，值为null

- 如果State在位，值为：

  | 属性值   | 场景1         | 场景2 | 场景3 | 场景4    | 场景5 |  场景6 |
  | -------- | ------------- | ----- | ----- | -------- | ----- | ----- |
  | State    | 1             | 1     | 1     | 1        | 0     | 255 |
  | Health   | 0             | 1     | 2     | 3        | null  | null |
  | Severity | Informational | Minor | Major | Critical | null  | null |

4）在oem下CapacitanceStatus对象下新增FaultDetails字段：

- 从资源协作接口获取属性值 HealthStatus，在redfish做映射

- 映射逻辑为

  | FaultDetails                 | HealthStatus |
  | ---------------------------- | ------------ |
  | Voltage Low                  | bit0 --- 1   |
  | Battery Needs To Be Replaced | bit1 --- 1   |
  | Learn Cycle Failed           | bit2 --- 1   |
  | Learn Cycle Timeout          | bit3 --- 1   |
  | Pack is about to fail        | bit4 --- 1   |
  | Remaining Capacity Low       | bit5 --- 1   |
  | No Space for Cache Offload   | bit6 --- 1   |
  | null                         | 0            |

5）支持在oem下新增FormFactor字段：

- 在Storage组件创建并且获取FormFactor属性

- 将FormFactor属性更新到资源协作接口

- 从资源协作接口获取属性值 FormFactor，在redfish做映射

- 映射逻辑为

  | FormFactor（redfish接口属性值）（字符串类型） | FormFactor（资源协作接口属性值）（整数类型） |
  | --------------------------------------------- | -------------------------------------------- |
  | Unknown                                       | 0                                            |
  | 5.25 inch                                     | 1                                            |
  | 3.5 inch                                      | 2                                            |
  | 2.5 inch                                      | 3                                            |
  | 1.8 inch                                      | 4                                            |
  | Less than 1.8 inch                            | 5                                            |
  | mSATA                                         | 6                                            |
  | M.2                                           | 7                                            |
  | MicroSSD                                      | 8                                            |
  | CFast                                         | 9                                            |
  | null                                          | 255                                          |

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

不涉及

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

如下功能实现所涉及的运行逻辑相同， 下图以JbodStateSupported字段为例：

| 功能编号 | 功能标题                                           | 功能描述                                           |
| -------- | -------------------------------------------------- | -------------------------------------------------- |
| 1        | 在oem下新增JbodStateSupported字段                  | 在oem下新增JbodStateSupported字段                  |
| 2        | 在oem下新增EpdSupported字段                        | 在oem下新增EpdSupported字段                        |
| 3        | 在oem下CapacitanceStatus对象下新增Severity字段     | 在oem下CapacitanceStatus对象下新增Severity字段     |
| 4        | 在oem下CapacitanceStatus对象下新增FaultDetails字段 | 在oem下CapacitanceStatus对象下新增FaultDetails字段 |

```mermaid
sequenceDiagram

  participant User

  participant redfish

  participant 资源协作接口

  User->>redfish:调用GET方法获取raid卡属性JbodStateSupported

  redfish->>资源协作接口:从资源协作接口获取属性JbodSupported

  资源协作接口->>redfish:资源协作接口返回属性值到redfish组件

  redfish->>User:返回查询信息

```

如下功能的运行逻辑视图为：

| 功能编号 | 功能标题                  | 功能描述                  |
| -------- | ------------------------- | ------------------------- |
| 1        | 在oem下新增FormFactor字段 | 在oem下新增FormFactor字段 |

```mermaid
sequenceDiagram
    participant User
    participant redfish
    participant 资源协作接口
    participant drive
    participant sml
    User->>redfish:调用GET方法获取尺寸信息
    redfish->>资源协作接口:获取FormFactor数值
    资源协作接口->>drive:获取pd_info结构体的form_factor属性值
    drive->>sml:获取pd_info结构体
    sml->>drive:返回pd_info结构体信息
    drive->>资源协作接口:更新FormFactor属性值
    资源协作接口->>redfish:使用FormFactor数值映射为尺寸信息
    redfish->>User:返回查询信息
```



### 2.1.2 内部依赖分析

<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->

依赖Storage组件获取pd_info结构体的接口，该接口已实现

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->

不涉及

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 在oem下新增JbodStateSupported字段 | NA | NA | NA | NA | NA | NA | 涉及 |
| 在oem下新增EpdSupported字段 | NA | NA | NA | NA | NA | NA | 涉及 |
| 在oem下CapacitanceStatus对象下新增Severity字段 | NA | NA | NA | NA | NA | NA | 涉及 |
| 在oem下CapacitanceStatus对象下新增FaultDetails字段 | NA | NA | NA | NA | NA | NA | 涉及 |
| 在oem下新增FormFactor字段 | NA | NA | NA | NA | NA | NA | 涉及 |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->

不影响

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->

不涉及定制化

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->

不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->

不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->

不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->

补充属性不涉及接口或命令

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

见上面的功能分析

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

不涉及

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->

可以直接验证

| 编号 | 描述                                                         | 操作步骤                                                     | 预期结果                                                     |
| ---- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| 1    | redfish查询JbodStateSupported和EpdSupported属性              | 1.使用GET方法<br/>2.通过redfish访问raid卡对象<br/>3.查看返回的信息 | 1.查询到的值为（true或者false）                              |
| 2    | 无电容场景下，redfish查询CapacitanceStatus对象下Severity和FaultDetails属性 | 1.使用GET方法<br/>2.通过redfish访问raid卡对象<br/>3.查看返回的信息 | 1.两个字段均为null                                           |
| 3    | 有电容场景下，redfish查询CapacitanceStatus对象下Severity和FaultDetails属性 | 1.使用GET方法<br/>2.通过redfish访问raid卡对象<br/>3.查看返回的信息 | 1.查询到非null值，且和资源协作接口对应（和资源协作接口对应关系见上） |
| 4    | 硬盘未插入情况下，redfish查询FormFactor属性                  | 1.使用GET方法<br/>2.通过redfish访问Drive对象<br/>3.查看返回的信息 | 1.值为“Unknown”                                              |
| 5    | 硬盘插入情况下，redfish查询FormFactor属性                    | 1.使用GET方法<br/>2.通过redfish访问raid卡对象<br/>3.查看返回的信息 | 1.值与资源写作接口对应（和资源协作接口对应关系见上）         |

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->

涉及redfish资料修改

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

不涉及

### 2.2.6 可靠性分析

1.OS下电场景redfish均能查询到对应的属性值，与OS上电时保持一致
2.硬盘插拔场景下，当硬盘被拔掉后，FormFactor的值为“unknwon”

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 不涉及 |  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 不涉及 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |  |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】支持redfish接口补齐Storages和Drive相关资源的功能实现

| 功能编号 | 功能标题                                           | 功能描述                                           |
| -------- | -------------------------------------------------- | -------------------------------------------------- |
| 1        | 在oem下新增JbodStateSupported字段                  | 在oem下新增JbodStateSupported字段                  |
| 2        | 在oem下新增EpdSupported字段                        | 在oem下新增EpdSupported字段                        |
| 3        | 在oem下CapacitanceStatus对象下新增Severity字段     | 在oem下CapacitanceStatus对象下新增Severity字段     |
| 4        | 在oem下CapacitanceStatus对象下新增FaultDetails字段 | 在oem下CapacitanceStatus对象下新增FaultDetails字段 |
| 5        | 在oem下新增FormFactor字段                          | 在oem下新增FormFactor字段                          |

### 3.1.1 功能实现设计

1. 在oem下新增JbodStateSupported字段
   - 直接从资源协作接口获取属性，在响应体中显示
2. 在oem下新增EpdSupported字段
   - 直接从资源协作接口获取属性，在响应体中显示
3. 在oem下CapacitanceStatus对象下新增Severity字段
   - 从资源协作接口获取电容的Status和Health值
   - 根据两个值做映射，映射到不同的字符串信息
   - 在响应体中显示
4. 在oem下CapacitanceStatus对象下新增FaultDetails字段
   - 从资源协作接口获取电容的HealthStatus值
   - 根据HealthStatus值做映射，映射到不同的字符串信息
   - 在响应体中显示
5. 在oem下新增FormFactor字段
   - Drive组件获取pd_info的form_factor属性值（U8）
   - 注册form_factor属性到资源协作接口
   - 从资源协作接口获取form_factor属性值
   - 根据form_factor值做映射，映射到不同的字符串信息
   - 在响应体中显示

### 3.1.2 功能详细设计

见上

### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->

#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->

不涉及

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->